/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.base.XMLHelper;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEObjectInfo
implements Serializable {
    private static final long serialVersionUID = 119075L;
    protected static final String BUMP_INDENT = "\t";
    public static final int UNSUPPORTED_PROPERTY_TYPE = -1;
    private VWGuid m_guid = null;
    private String m_displayName = null;
    private String m_symbolicName = null;
    private VWGuid m_xpdlGuid = null;
    private Hashtable<String, PropTypeInfo> m_propertyTypeList = new Hashtable();
    private Hashtable<String, Object> m_propertyValueList = new Hashtable();

    public CEObjectInfo(String guid, String displayName) throws VWException {
        this(guid, displayName, null, null);
    }

    public CEObjectInfo(String guid, String displayName, String symbolicName) throws VWException {
        this(guid, displayName, symbolicName, null);
    }

    public CEObjectInfo(String guid, String displayName, String symbolicName, String xpdlGuid) throws VWException {
        this.m_guid = new VWGuid(guid);
        this.m_displayName = displayName;
        this.m_symbolicName = symbolicName;
        if (xpdlGuid != null) {
            this.m_xpdlGuid = new VWGuid(xpdlGuid);
        }
    }

    public String getGuid() {
        if (this.m_guid != null) {
            return this.m_guid.toString();
        }
        return null;
    }

    public String getXpdlGuid() {
        if (this.m_xpdlGuid != null) {
            return this.m_xpdlGuid.toString();
        }
        return null;
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public boolean hasPropertyType(String propertyName) {
        return this.m_propertyTypeList.containsKey(propertyName);
    }

    public int getPropertyType(String propertyName) {
        if (this.m_propertyTypeList.containsKey(propertyName)) {
            PropTypeInfo typeInfo = this.m_propertyTypeList.get(propertyName);
            return typeInfo.m_type;
        }
        return -1;
    }

    public void setPropertyType(String propertyName, int nType, boolean bIsArray) {
        this.m_propertyTypeList.put(propertyName, new PropTypeInfo(nType, bIsArray));
    }

    public String[] getPropertyTypeNames() {
        Set<String> keySet = this.m_propertyTypeList.keySet();
        return keySet.toArray(new String[0]);
    }

    public boolean getPropertyIsArray(String propertyName) {
        if (this.m_propertyTypeList.containsKey(propertyName)) {
            PropTypeInfo typeInfo = this.m_propertyTypeList.get(propertyName);
            return typeInfo.m_isArray;
        }
        return false;
    }

    public boolean hasPropertyValue(String propertyName) {
        return this.m_propertyValueList.containsKey(propertyName);
    }

    public Object getPropertyValue(String propertyName) {
        if (this.m_propertyValueList.containsKey(propertyName)) {
            return this.m_propertyValueList.get(propertyName);
        }
        return null;
    }

    public void setPropertyValue(String propertyName, Object value) {
        this.m_propertyValueList.put(propertyName, value);
    }

    public String[] getPropertyValueNames() {
        Set<String> keySet = this.m_propertyValueList.keySet();
        return keySet.toArray(new String[0]);
    }

    public String toString() {
        if (this.m_displayName != null && this.m_displayName.length() > 0) {
            return this.m_displayName;
        }
        if (this.m_symbolicName != null && this.m_symbolicName.length() > 0) {
            return this.m_symbolicName;
        }
        return this.getGuid();
    }

    public void toXML(String indentA, StringBuffer theBuffer) throws VWException {
        String[] propertyNames;
        if (theBuffer == null) {
            throw new VWException("vw.base.CEObjectInfoNullBuffer", "The buffer parameter can not be null.");
        }
        theBuffer.append(indentA + "<CEObjectInfoObject");
        theBuffer.append(" Id=\"" + XMLHelper.toXMLString(this.getGuid()) + "\"");
        if (this.m_displayName != null) {
            theBuffer.append(" Name=\"" + XMLHelper.toXMLString(this.m_displayName) + "\"");
        }
        if (this.m_symbolicName != null) {
            theBuffer.append(" SymbolicName=\"" + XMLHelper.toXMLString(this.m_symbolicName) + "\"");
        }
        if ((propertyNames = this.getPropertyTypeNames()) != null && propertyNames.length > 0) {
            theBuffer.append(">\n");
            String PROPERTY_INDENT = indentA + BUMP_INDENT;
            for (int i = 0; i < propertyNames.length; ++i) {
                int nType = this.getPropertyType(propertyNames[i]);
                if (!VWFieldType.isValid(nType)) continue;
                theBuffer.append(PROPERTY_INDENT + "<Property");
                theBuffer.append(" Name=\"" + XMLHelper.toXMLString(propertyNames[i]) + "\"");
                theBuffer.append(" Type=\"" + VWFieldType.typeToString(nType) + "\"");
                theBuffer.append(" IsArray=\"" + Boolean.toString(this.getPropertyIsArray(propertyNames[i])) + "\"/>\n");
            }
            theBuffer.append(indentA + "</CEObjectInfoObject>\n");
        } else {
            theBuffer.append("/>\n");
        }
    }

    public void bootstrapPropertyLists(CEObjectInfo baseCEObjectInfo) {
        this.m_propertyTypeList = baseCEObjectInfo.getPropertyTypeListClone();
        this.m_propertyValueList = baseCEObjectInfo.getPropertyValueListClone();
    }

    protected Hashtable<String, PropTypeInfo> getPropertyTypeListClone() {
        return (Hashtable)this.m_propertyTypeList.clone();
    }

    protected Hashtable<String, Object> getPropertyValueListClone() {
        return (Hashtable)this.m_propertyValueList.clone();
    }

    private static class PropTypeInfo
    implements Serializable {
        private static final long serialVersionUID = 119075L;
        int m_type;
        boolean m_isArray;

        PropTypeInfo(int _type, boolean _isArray) {
            this.m_type = _type;
            this.m_isArray = _isArray;
        }
    }
}

